#!/usr/bin/python

# Argumets:
# 1) EAE/States
# 2) full grid direct dimension
# 3) full grid indirect dimension
# 4) p0_dir
# 5) p1_dir
# 6) p0_indir
# 7) sampling schedule file - indirect dimension (!)
# 8) sampling schedule file - direct dimension (!)
# 9) Algorithm (IST/IRLS)
# 10) Number of iterations
# 11) Virtual echo (y/n)

# ./2D_varian_direct_chunks_indirect_nus.py EAE 1050 192 0 0 0 F1.sch F2.sch IST 100 n

from numpy import *
import nmrglue as ng
import sys
import os
import struct

print "\nReading data...",
dic, data = ng.fileio.varian.read(fid_file='fid', procpar_file='procpar')
D = size(data, 1) # direct dimension full grid 
print "done!\n"

### Echo-antiecho -> states
if sys.argv[1]=='EAE':
    print "\nConverting 'Echo-antiecho' to 'States'...",
    data1 = zeros(shape(data), dtype=complex)
    i = 0
    while i<((shape(data))[0]):
        data1[i, :] = ((data[i, :]) + data[i + 1, :])/2
        data1[i + 1, :] = 1j*((-data[i, :] + data[i + 1, :])/2)
        i = i + 2
    data = data1 
    print "done!\n"
elif sys.argv[1] == 'S':
    print "\n'States' mode assumed."
else:
    print "\nNo quadrature given! Script terminated."
    sys.exit() 
    
d1 = int(sys.argv[2]) # full grid - direct dimension
d2 = int(sys.argv[3]) # full grid - indirect dimension

### Direct dimesion phasing
print "\nPhasing...",
p0_dir = float(sys.argv[4]) 
data = data*exp(-1j*p0_dir*pi/180) # complex numbers correspond to direct dimension
p1_dir = float(sys.argv[5]) 
data = fft.fft(data, axis = 1)
for i in range(shape(data)[0]):
    data[i, :] = data[i, :]*exp(-1j*arange(d1)*p1_dir/d1)
data = fft.ifft(data, axis = 1) # fft with axis=0: "over columns", along rows


p0_indir = float(sys.argv[6])
data_r_indirect = real(data)[0::2, :] + 1j*real(data)[1::2, :] # 'artificial' complex numbers in indirect dimension
data_r_indirect = data_r_indirect*exp(-1j*p0_indir) # phasing indirect dimension
data_r_indirect1 = zeros(shape(data), dtype = complex)
data_r_indirect1[0::2, :] = real(data_r_indirect) 
data_r_indirect1[1::2, :] = imag(data_r_indirect)

data_i_indirect = imag(data)[0::2, :] + 1j*imag(data)[1::2, :]
data_i_indirect = data_i_indirect*exp(-1j*p0_indir) 
data_i_indirect1 = zeros(shape(data), dtype = complex)
data_i_indirect1[0::2, :] = real(data_i_indirect) 
data_i_indirect1[1::2, :] = imag(data_i_indirect)

data = data_r_indirect1 + 1j*data_i_indirect1 # complex numbers correspond to direct dimension
print "done!\n"

### Schedule for MDD
print "\nReading sampling scheme...",
sched1 = loadtxt(sys.argv[7])
sched1 = sched1.astype(int)
sched2 = loadtxt(sys.argv[8])
sched2 = sched2.astype(int)

data=ng.process.proc_base.tp_hyper(data) #!
data=ng.process.proc_base.tp_hyper(data) #!

ni1=len(sched1)
ni2=len(sched2)
nitot=ni1*ni2
nimax1=d1

s = ''
for i in range(len(sched1)):
    for j in range(len(sched2)):
        s = s + '\n' + str(0) + ' ' + str(sched1[i]*2) + ' ' + str(sched2[j]*2)
        s = s + '\n' + str(0) + ' ' + str(sched1[i]*2) + ' ' + str(sched2[j]*2 + 1)
        s = s + '\n' + str(0) + ' ' + str(sched1[i]*2 + 1) + ' ' + str(sched2[j]*2)
        s = s + '\n' + str(0) + ' ' + str(sched1[i]*2 + 1) + ' ' + str(sched2[j]*2 + 1)   
print "done!\n"
    
### FID for MDD
fid = data[:,sched2]
fidcos=fid[0::2,:]
fidsin=fid[1::2,:]

fid_alternated = empty(nitot*4)

k=0
for i in range(ni1):	
    for j in range(ni2):
        fid_alternated[k+3]=real(fidcos[i,j])
        fid_alternated[k+2]=imag(fidcos[i,j])
        fid_alternated[k+1]=real(fidsin[i,j])
        fid_alternated[k]=imag(fidsin[i,j])
        k=k+4

### Writing to file .MDD
print "\nPreparing .mdd file...",
regions = 1
dimensions = 3

line1 = str(dimensions) + ' 1 ' + str(regions*4*len(sched1)*len(sched2)) + '\n'
line2 = str(regions) + ' ' + str(2*nimax1) + ' ' + str(2*D)

s = line1 + line2 + s
f = ''
for i in range(len(fid_alternated)):
    f = f + '\n' + str(fid_alternated[i])
contents = 'mdd asc sparse f180.0 \n ./MDD/region01.mdd \n MDD sparse\n $ \n' + s + f # contains the data to be written to .mdd file

folder = os.getcwd() + '/MDD/' 
if not os.path.exists(folder):
    os.makedirs(folder)
os.chdir(folder)
file = open('region01.mdd', 'w')
file.write(contents)
file.close()
print "done!\n"

print "\nReconstructing gaps..."
os.system("tcsh -c  'cssolver region01 CS_alg="+sys.argv[9]+" CS_niter="+sys.argv[10]+" CS_VE="+sys.argv[11]+" CS_ZF=2 MDD_NOISE=1 > region01.log'") # executes .mdd file
print "done!\n"

### Reading .CS file
print "\nReading .cs file...",
file = open('region01.cs', 'rb')
cs = empty(4*nimax1*D)
for i in range(4*nimax1*D):
    cs[i] = float(struct.unpack('f', file.read(4))[0])
file.close()

fid_rec=reshape(cs,(2*nimax1,2*D), order='F')
fid_rec=fid_rec[:,0::2]+1j*fid_rec[:,1::2]
fid_rec[0::2,:]=-fid_rec[0::2,:]
fid_rec=conj(fid_rec)

os.chdir("..")
dic['ni']=nimax1
dic['np']=2*D
dic["nblocks"]=nimax1*2

fid_rec1 = zeros(shape(fid_rec), dtype=complex)
i = 0

if sys.argv[1]=='EAE':
    print "\nConverting 'States' to 'Echo-antiecho'...",
    while i<((shape(fid_rec))[0]):
        fid_rec1[i+1, :] = ((fid_rec[i+1, :]) + 1j*fid_rec[i , :])/2
        fid_rec1[i, :] = ((fid_rec[i+1, :]) - 1j*fid_rec[i , :])/2
        i = i + 2
    fid_rec1 = fid_rec1*exp(1j*pi/2) 
    fid_rec=fid_rec1
    print "done!\n"
    
### Wrinting to .FID file
print "\nMaking fid_rec file..."
ng.fileio.varian.write_fid('fid_rec', dic, fid_rec, overwrite=True)
print "done!\n"

